<?php
function lcm_loyalty_cards_shortcode() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'loyalty_cards';
    $goal = intval(get_option('lcm_total_checkmarks', 10));

    // Get all cardholders
    $rows = $wpdb->get_results("SELECT * FROM $table_name ORDER BY name ASC");

    ob_start();
    ?>
    <form id="lcm-search-form" method="post">
        <input type="text" name="lcm_search" placeholder="Search cardholders..." />
        <input type="submit" value="Search" />
    </form>

    <div id="lcm-search-results"></div>

    <h3>All Cardholders</h3>
    <ul>
    <?php foreach ($rows as $row): ?>
        <li><?php
            $name = trim($row->name);
            if (strpos($name, ' ') !== false) {
                $parts = explode(' ', $name, 2);
                $fname = $parts[0];
                $lname = strtoupper(substr($parts[1], 0, 1));
                $display = "$fname $lname";
            } else {
                $display = $name;
            }
            echo esc_html("$display — {$row->progress} of $goal stamps");
        ?></li>
    <?php endforeach; ?>
    </ul>

    
    <?php
    return ob_get_clean();
}
add_shortcode('loyalty_cards', 'lcm_loyalty_cards_shortcode');
?>
