<?php
function lcm_register_settings() {
    register_setting('lcm-settings-group', 'lcm_total_checkmarks');
    register_setting('lcm-settings-group', 'lcm_email_subject');
    register_setting('lcm-settings-group', 'lcm_email_body');
    register_setting('lcm-settings-group', 'lcm_email_from_name');
    register_setting('lcm-settings-group', 'lcm_email_from_email');
    register_setting('lcm-settings-group', 'lcm_phone_optional');
    register_setting('lcm-settings-group', 'lcm_email_optional');
}
add_action('admin_init', 'lcm_register_settings');

function lcm_render_settings_page() {
    ?>
    <div class="wrap">
        <h1>Loyalty Card Settings</h1>
        <form method="post" action="options.php">
            <?php settings_fields('lcm-settings-group'); ?>
            <?php do_settings_sections('lcm-settings-group'); ?>
            <table class="form-table">
                <tr valign="top">
                    <th scope="row">Default Total Checkmarks</th>
                    <td><input type="number" name="lcm_total_checkmarks" value="<?php echo esc_attr(get_option('lcm_total_checkmarks', 10)); ?>" /></td>
                </tr>
                <tr valign="top">
                    
                <tr valign="top">
                    <th scope="row">From Name</th>
                    <td><input type="text" name="lcm_email_from_name" value="<?php echo esc_attr(get_option('lcm_email_from_name', get_bloginfo('name'))); ?>" size="50" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row">From Email</th>
                    <td><input type="email" name="lcm_email_from_email" value="<?php echo esc_attr(get_option('lcm_email_from_email', get_option('admin_email'))); ?>" size="50" /></td>
                </tr>
<th scope="row">Email Subject</th>
                    <td><input type="text" name="lcm_email_subject" value="<?php echo esc_attr(get_option('lcm_email_subject', 'You’ve earned a reward!')); ?>" size="50" /></td>
                </tr>
                <tr valign="top">
                    <th scope="row">Email Body</th>
                    <td><textarea name="lcm_email_body" rows="6" cols="50"><?php echo esc_textarea(get_option('lcm_email_body', 'Hi {name}, you have reached {current}/{max} and earned your reward!')); ?></textarea></td>
                </tr>
                <tr valign="top">
                    <th scope="row">Make Phone Optional</th>
                    <td><label><input type="checkbox" name="lcm_phone_optional" value="1" <?php checked(1, get_option('lcm_phone_optional', 0)); ?> /> If checked, phone won’t be required on the admin cardholder form.</label></td>
                </tr>
                <tr valign="top">
                    <th scope="row">Make Email Optional</th>
                    <td><label><input type="checkbox" name="lcm_email_optional" value="1" <?php checked(1, get_option('lcm_email_optional', 0)); ?> /> If checked, email won’t be required on the admin cardholder form.</label></td>
                </tr>
				<tr valign="top">
    <th scope="row"><?php esc_html_e( 'Loyalty Card Shortcode', 'lcm' ); ?></th>
    <td>
        <input 
            type="text" 
            class="regular-text code" 
            readonly 
            onclick="this.select();" 
            value="<?php echo esc_attr( '[loyalty_cards]' ); ?>" 
        />
        <p class="description">
            <?php esc_html_e( 'Click to select and copy this shortcode into any page or post.', 'lcm' ); ?>
        </p>
    </td>
</tr>
            </table>
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
}
?>
