<?php
require_once __DIR__ . '/includes/class-lcm-migrations.php';
register_activation_hook( __FILE__, function(){ if ( class_exists('LCM_Migrations_301') ) LCM_Migrations_301::run(); });
add_filter('set-screen-option', function($status,$option,$value){ if('lcm_per_page'===$option){ return (int)$value; } return $status; }, 10, 3);

/**
 * Plugin Name: Loyalty Card Manager
 * Plugin URI: https://www.myislanddesigns.com/loyalty-card-manager-plugin-for-wordpress
 * Description: Track customer visits using a digital loyalty card system. Admins can award checkmarks, send automatic reward emails, and display progress via shortcode.
* Version: 3.07
 * Author: My Island Designs
 * Author URI: http://www.myislanddesigns.com
 * License: GPL v2 or later
 */
 
/**
 * Override PHPMailer From name and email using plugin settings
 */
// —— FORCE FROM USING PLUGIN SETTINGS ——
add_filter('wp_mail_from', function($email) {
    $opt = get_option('lcm_email_from_email');
    return $opt ? $opt : get_option('admin_email');
}, 99);
add_filter('wp_mail_from_name', function($name) {
    $opt = get_option('lcm_email_from_name');
    return $opt ? $opt : get_bloginfo('name');
}, 99);
function lcm_set_mailer($phpmailer) {
    $email = get_option('lcm_email_from_email');
    if (!$email) {
        $email = get_option('admin_email');
    }
    $name = get_option('lcm_email_from_name');
    if (!$name) {
        $name = get_bloginfo('name');
    }
    $phpmailer->Sender    = $email;
    $phpmailer->From      = $email;
    $phpmailer->FromName  = $name;
    $phpmailer->clearReplyTos();
    $phpmailer->addReplyTo($email, $name);
}
add_action('phpmailer_init', 'lcm_set_mailer');
/**
 * Plugin Name: Loyalty Card Manager
 * Plugin URI: http://www.myislanddesigns.com/
 * Description: Track customer visits using a digital loyalty card system. Admins can award checkmarks, send automatic reward emails, and display progress via shortcode.
* Version: 3.07
 * Author: My Island Designs
 * Author URI: http://www.myislanddesigns.com
 * License: GPL v2 or later
 */

if (!defined('ABSPATH')) exit;

require_once plugin_dir_path(__FILE__) . 'functions.php';
require_once plugin_dir_path(__FILE__) . 'settings.php';
require_once plugin_dir_path(__FILE__) . 'admin-page.php';
require_once plugin_dir_path(__FILE__) . 'shortcodes.php';
require_once plugin_dir_path(__FILE__) . 'ajax-handler.php';

function lcm_enqueue_styles() {
    wp_enqueue_style('lcm-admin-style', plugin_dir_url(__FILE__) . 'assets/admin.css');
}
add_action('admin_enqueue_scripts', 'lcm_enqueue_styles');

function lcm_enqueue_popup_assets() {
    if (is_singular() && has_shortcode(get_post()->post_content, 'loyalty_cards')) {
        wp_enqueue_script('lcm-search-popup', plugin_dir_url(__FILE__) . 'assets/search-popup.js', array('jquery'), null, true);
        wp_enqueue_style('lcm-search-style', plugin_dir_url(__FILE__) . 'assets/search-popup.css');
        wp_localize_script('lcm-search-popup', 'lcm_ajax_obj', array(
            'ajax_url' => admin_url('admin-ajax.php')
        ));
    }
}
add_action('wp_enqueue_scripts', 'lcm_enqueue_popup_assets');

register_activation_hook(__FILE__, 'lcm_create_table');

function lcm_admin_menu() {
    add_menu_page(
        'Loyalty Card Manager',
        'Loyalty Cards',
        'manage_options',
        'lcm-admin',
        'lcm_render_admin_page',
        'dashicons-id',
        30
    );
    add_submenu_page(
        'lcm-admin',
        'Loyalty Card Settings',
        'Settings',
        'manage_options',
        'lcm-settings',
        'lcm_render_settings_page'
    );
}
add_action('admin_menu', 'lcm_admin_menu');

require_once plugin_dir_path(__FILE__) . 'cardholder-details.php';

// [lcm_card_status] shortcode

function lcm_card_status_shortcode() {
    global $wpdb;
    $table = $wpdb->prefix . 'loyalty_cards';
    $output = '';
    if (is_user_logged_in()) {
        $current_user = wp_get_current_user();
        $email = sanitize_email($current_user->user_email);
        $row = $wpdb->get_row($wpdb->prepare("SELECT * FROM $table WHERE email = %s", $email));
        if ($row) {
            $output .= "<h2>Your Loyalty Card</h2>";
            $output .= "<p>Name: " . esc_html($row->name) . "</p>";
            $output .= "<p>Progress: " . intval($row->progress) . " / " . intval(get_option('lcm_total_checkmarks', 10)) . "</p>";
        } else {
            $output .= "<p>No loyalty card found for your account.</p>";
        }
    }

    $output .= "<h2>Redeemed Cards</h2><ul>";
    $redeemed = $wpdb->get_results("SELECT name, redemptions FROM $table WHERE redemptions > 0 ORDER BY redemptions DESC, name ASC");
    foreach ($redeemed as $r) {
        $name = trim($r->name);
        if (strpos($name, ' ') !== false) {
            $parts = explode(' ', $name, 2);
            $fname = $parts[0];
            $lname = strtoupper(substr($parts[1], 0, 1));
            $display = "$fname $lname";
        } else {
            $display = $name;
        }
        $plural = $r->redemptions > 1 ? 's' : '';
        $output .= "<li>" . esc_html($display) . " — " . intval($r->redemptions) . " redeemed card" . $plural . "</li>";
    }
    $output .= "</ul>";
    return $output;
}
add_shortcode('lcm_card_status', 'lcm_card_status_shortcode');
