<?php
if ( ! defined( 'ABSPATH' ) ) exit;

class LCM_Migrations_301 {
	public static function run() {
		global $wpdb;
		$table = $wpdb->prefix . 'loyalty_cards';

		$exists = $wpdb->get_var( $wpdb->prepare("SHOW TABLES LIKE %s", $table) );
		if ( $exists !== $table ) { return; }

		$col = $wpdb->get_var( "SHOW COLUMNS FROM {$table} LIKE 'updated_at'" );
		if ( ! $col ) {
			$wpdb->query( "ALTER TABLE {$table} ADD COLUMN updated_at DATETIME NULL" );
		}

		$wpdb->query( "UPDATE {$table} SET updated_at = IFNULL(updated_at, NOW()) WHERE updated_at IS NULL" );

		if ( ! $wpdb->get_var( $wpdb->prepare("SHOW INDEX FROM {$table} WHERE Key_name=%s", 'idx_updated_at') ) ) {
			$wpdb->query( "CREATE INDEX idx_updated_at ON {$table} (updated_at)" );
		}
		if ( ! $wpdb->get_var( $wpdb->prepare("SHOW INDEX FROM {$table} WHERE Key_name=%s", 'idx_name') ) ) {
			$wpdb->query( "CREATE INDEX idx_name ON {$table} (name)" );
		}
	}
}
