<?php
function lcm_create_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'loyalty_cards';
    $charset_collate = $wpdb->get_charset_collate();

    if (!function_exists('dbDelta')) {
        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
    }

    $sql = "CREATE TABLE $table_name (
        id mediumint(9) NOT NULL AUTO_INCREMENT,
        name varchar(255) NOT NULL,
        email varchar(255) NOT NULL,
        phone varchar(100) DEFAULT '',
        progress int NOT NULL DEFAULT 0,
        redemptions int NOT NULL DEFAULT 0,
        reward_sent tinyint(1) DEFAULT 0,
        service text DEFAULT '',
        notes text,
        created_at datetime DEFAULT CURRENT_TIMESTAMP,
        PRIMARY KEY  (id)
    ) $charset_collate;";

    dbDelta($sql);

// Create loyalty_visits table on activation if it doesn't exist
function lcm_create_visits_table() {
    global $wpdb;
    $visit_table = $wpdb->prefix . 'loyalty_visits';
    $charset_collate = $wpdb->get_charset_collate();
    if ($wpdb->get_var("SHOW TABLES LIKE '$visit_table'") != $visit_table) {
        if (!function_exists('dbDelta')) {
            require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        }
        $sql = "CREATE TABLE $visit_table (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            cardholder_id BIGINT(20) UNSIGNED NOT NULL,
            visit_time DATETIME NOT NULL,
            service_note TEXT,
            PRIMARY KEY  (id),
            KEY cardholder_id (cardholder_id)
        ) $charset_collate;";
        dbDelta($sql);
    }
}
register_activation_hook(__FILE__, 'lcm_create_visits_table');

}


// Auto-upgrade: Add missing 'service' column if it doesn't exist
function lcm_check_service_column() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'loyalty_cards';
    $column_exists = $wpdb->get_results("SHOW COLUMNS FROM `$table_name` LIKE 'service'");
    if (empty($column_exists)) {
        $wpdb->query("ALTER TABLE `$table_name` ADD `service` TEXT DEFAULT ''");
    }
}
add_action('admin_init', 'lcm_check_service_column');
