<?php
function lcm_render_cardholder_details() {
    if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
        echo '<div class="wrap"><h2>Invalid Cardholder ID</h2></div>';
        return;
    }

    global $wpdb;
    $id = intval($_GET['id']);
    $cardholder = $wpdb->get_row($wpdb->prepare("SELECT * FROM {$wpdb->prefix}loyalty_cards WHERE id = %d", $id));
    if (!$cardholder) {
        echo '<div class="wrap"><h2>Cardholder Not Found</h2></div>';
        return;
    }

    $visits = $wpdb->get_results($wpdb->prepare("SELECT visit_time, service_note FROM {$wpdb->prefix}loyalty_visits WHERE cardholder_id = %d ORDER BY visit_time DESC", $id));

    echo '<div class="wrap">';
    echo '<h1>Visit History for ' . esc_html($cardholder->name) . '</h1>';
    echo '<p><strong>Email:</strong> ' . esc_html($cardholder->email) . '</p>';
    echo '<p><strong>Phone:</strong> ' . esc_html($cardholder->phone) . '</p>';
    echo '<p><strong>Notes:</strong> ' . esc_html($cardholder->notes) . '</p>';
    echo '<p><strong>Progress:</strong> ' . intval($cardholder->progress) . '</p>';

    echo '<h2>Visit Timeline</h2>';
    if (!empty($visits)) {
        echo '<ul>';
        foreach ($visits as $visit) {
    $display_time = date_i18n('F j, Y, g:i a T', strtotime($visit->visit_time));
    $note = $visit->service_note ? ' – ' . esc_html($visit->service_note) : '';
    echo '<li>' . esc_html($display_time) . $note . '</li>';
}
        echo '</ul>';
    } else {
        echo '<p>No visits recorded yet.</p>';
    }

    if (isset($_POST['resend_email']) && isset($_POST['to_email'])) {
        $to_email = sanitize_email($_POST['to_email']);
        $to_name = sanitize_text_field($_POST['to_name']);
        $subject = sanitize_text_field($_POST['subject']);
        $body = stripslashes(wp_kses_post($_POST['message']));

        $from_email = get_option('lcm_email_from_email', get_option('admin_email'));
        $from_name = get_option('lcm_email_from_name', get_bloginfo('name'));
        $headers = [
            'From: ' . $from_name . ' <' . $from_email . '>',
            'Reply-To: ' . $from_name . ' <' . $from_email . '>'
        ];

        wp_mail($to_email, $subject, $body, $headers);
        echo '<div class="notice notice-success is-dismissible"><p>Reward email sent to ' . esc_html($to_name) . '.</p></div>';
    }

    $name = esc_html($cardholder->name);
    $goal = intval(get_option('lcm_total_checkmarks', 10));
    $current = intval($cardholder->progress);
    $name = esc_html($cardholder->name);
    $message = "Hi {$name},

";
    $message .= "You've officially earned your loyalty reward — {$current}/{$goal} stamps collected!

";
    $message .= "On your next visit, treat yourself to a free regular pedicure or $30 off any service — it's our way of saying thank you for being amazing.

";
    $message .= "We can’t wait to pamper you again soon!

";
    $message .= "Congratulations,
";
    $message .= "The VIP Nails & Facials Team

";
    $message .= "Iris Turner
";
    $message .= "VIP Nails & Facials
";
    $message .= "325 E Merritt Island Cswy
";
    $message .= "Merritt Island, FL 32952

";
    $message .= "Phone: (321) 806-3981
";
    $message .= "Email: vipcare@vipnailsandfacials.com";

    echo '<h2>Resend Reward Email</h2>';
    echo '<form method="post">';
    echo '<p><label>To Name: <input type="text" name="to_name" value="' . esc_attr($cardholder->name) . '" class="regular-text"></label></p>';
    echo '<p><label>To Email: <input type="email" name="to_email" value="' . esc_attr($cardholder->email) . '" class="regular-text"></label></p>';
    echo "<p><label>Subject: <input type=\"text\" name=\"subject\" value=\"You’ve Earned a Reward from VIP Nails & Facials!\" class=\"large-text\"></label></p>";
    echo '<p><label>Message:</label><br><textarea name="message" rows="6" class="large-text">' . htmlspecialchars($message, ENT_NOQUOTES) . '</textarea></p>';
    echo '<p><input type="submit" name="resend_email" class="button-primary" value="Send Email"></p>';
    echo '</form>';

    echo '</div>';
}

add_action('admin_menu', function () {
    add_submenu_page(
        'lcm-admin',
        'Cardholder Details',
        'Cardholder Details',
        'manage_options',
        'lcm-cardholder-details',
        'lcm_render_cardholder_details'
    );
});
