jQuery(document).ready(function($) {
    $('#lcm-search-form').on('submit', function(e) {
        e.preventDefault();
        const searchVal = $('input[name="lcm_search"]').val();
        $.post(lcm_ajax_obj.ajax_url, {
            action: 'lcm_search',
            search: searchVal
        }, function(response) {
            const popup = `
                <div id="lcm-popup-overlay">
                    <div class="lcm-popup-content">
                        <span id="lcm-close-popup">×</span>
                        ${response}
                    </div>
                </div>`;
            $('#lcm-popup-overlay').remove(); // Remove any existing overlay
            $('body').append(popup);
        });
    });

    $(document).on('click', '#lcm-close-popup', function() {
        $('#lcm-popup-overlay').remove();
    });

    $(document).on('click', '#lcm-popup-overlay', function(e) {
        if ($(e.target).is('#lcm-popup-overlay')) {
            $('#lcm-popup-overlay').remove();
        }
    });
});
