<?php
function lcm_handle_ajax_search() {
    global $wpdb;
    $search = isset($_POST['search']) ? sanitize_text_field($_POST['search']) : '';
    $table_name = $wpdb->prefix . 'loyalty_cards';
    $goal = intval(get_option('lcm_total_checkmarks', 10));

    $query = "SELECT * FROM $table_name";
    if (!empty($search)) {
        $query .= $wpdb->prepare(" WHERE name LIKE %s OR email LIKE %s OR phone LIKE %s", "%$search%", "%$search%", "%$search%");
    }
    $query .= " ORDER BY name ASC";
    $rows = $wpdb->get_results($query);

    echo '<h3>Search Results</h3><ul>';
    foreach ($rows as $row) {
        $name = trim($row->name);
        $fname = $name;
        $lname = '';
        if (strpos($name, ' ') !== false) {
            $parts = explode(' ', $name, 2);
            $fname = $parts[0];
            $lname = strtoupper(substr($parts[1], 0, 1));
        }
        $display = trim("$fname $lname");
        echo "<li>" . esc_html("$display — {$row->progress} of $goal stamps") . "</li>";
    }
    echo '</ul>';
    wp_die();
}
add_action('wp_ajax_lcm_search', 'lcm_handle_ajax_search');
add_action('wp_ajax_nopriv_lcm_search', 'lcm_handle_ajax_search');
?>
