<?php
if ( ! defined( 'ABSPATH' ) ) exit;

function lcm_render_paginated_page() {
	if ( ! class_exists('LCM_List_Table') ) {
		require_once plugin_dir_path(__FILE__) . '../class-lcm-list-table.php';
	}
	global $wpdb;
	$table = $wpdb->prefix . 'loyalty_cards';
	$visit_table = $wpdb->prefix . 'loyalty_visits';
	$now = current_time('mysql');

	// ------- HANDLERS -------

	// Add cardholder
	if ( isset($_POST['lcm_add_cardholder']) && check_admin_referer('lcm_add') ) {
		$name    = sanitize_text_field($_POST['name'] ?? ($_POST['lcm_name'] ?? ''));$email   = sanitize_email($_POST['email'] ?? ($_POST['lcm_email'] ?? ''));$phone   = sanitize_text_field($_POST['phone'] ?? ($_POST['lcm_phone'] ?? ''));$service = sanitize_text_field($_POST['service'] ?? ($_POST['lcm_service'] ?? ''));$notes   = sanitize_textarea_field($_POST['notes'] ?? ($_POST['lcm_notes'] ?? ''));$progress= isset($_POST['progress']) ? max(0, intval($_POST['progress'])) : 0;

		if ( $name !== '' ) { // server-side guard to prevent blank rows
			$wpdb->insert( $table, [
				'name'=>$name, 'email'=>$email, 'phone'=>$phone,
				'service'=>$service, 'notes'=>$notes, 'progress'=>$progress, 'reward_sent'=>0
			]);
			$new_id = (int) $wpdb->insert_id;
			if ( $new_id ) {
				$wpdb->update( $table, ['updated_at'=>$now], ['id'=>$new_id] );
				// Seed visits to match initial progress
				if ( $progress > 0 ) {
					for ( $i=0; $i<$progress; $i++ ) {
						$wpdb->insert( $visit_table, ['cardholder_id'=>$new_id, 'visit_time'=>$now, 'service_note'=>$service] );
					}
				}
				$_GET['edit_id'] = $new_id; // open quick edit immediately
				echo '<div class="notice notice-success"><p>Cardholder added.</p></div>';
			}
		} else {
			echo '<div class="notice notice-error"><p>Name is required.</p></div>';
		}
	}

	// Quick Edit Save (full field update, sync visits)
	if ( isset($_POST['lcm_save_cardholder']) && isset($_POST['cardholder_id']) ) {
		$id = intval($_POST['cardholder_id']);
		if ( wp_verify_nonce( $_POST['_wpnonce'] ?? '', 'lcm_edit_'.$id ) ) {
			// Read current to compute progress delta
			$cur = $wpdb->get_row( $wpdb->prepare("SELECT progress FROM {$table} WHERE id=%d", $id) );
			$old_progress = $cur ? (int)$cur->progress : 0;
			$new_progress = max(0, intval($_POST['lcm_edit_progress'] ?? 0));

			$data = [
				'name'    => sanitize_text_field($_POST['lcm_edit_name'] ?? ''),
				'email'   => sanitize_email($_POST['lcm_edit_email'] ?? ''),
				'phone'   => sanitize_text_field($_POST['lcm_edit_phone'] ?? ''),
				'notes'   => sanitize_textarea_field($_POST['lcm_edit_notes'] ?? ''),
				'service' => sanitize_text_field($_POST['lcm_edit_service'] ?? ''),
				'progress'=> $new_progress,
			];
			$wpdb->update( $table, $data, ['id'=>$id] );
			$wpdb->update( $table, ['updated_at'=>$now], ['id'=>$id] );

			$delta = $new_progress - $old_progress;
			if ( $delta > 0 ) {
				for ( $i=0; $i<$delta; $i++ ) {
					$wpdb->insert( $visit_table, ['cardholder_id'=>$id, 'visit_time'=>$now, 'service_note'=>$data['service']] );
				}
			} elseif ( $delta < 0 ) {
				$to_remove = abs($delta);
				$ids = $wpdb->get_col( $wpdb->prepare("SELECT id FROM {$visit_table} WHERE cardholder_id=%d ORDER BY visit_time DESC, id DESC LIMIT %d", $id, $to_remove) );
				if ( $ids ) {
					foreach ( $ids as $vid ) {
						$wpdb->delete( $visit_table, ['id'=>intval($vid)] );
					}
				}
			}

			echo '<div class="notice notice-success"><p>Cardholder updated.</p></div>';
		}
	}

	// Progress +/- (keep visits in sync)
	if ( isset($_POST['lcm_progress_delta']) && isset($_POST['cardholder_id']) ) {
		$id = intval($_POST['cardholder_id']);
		if ( wp_verify_nonce( $_POST['_wpnonce'] ?? '', 'lcm_prog_'.$id ) ) {
			$delta = intval($_POST['lcm_progress_delta']);
			$cur = (int) $wpdb->get_var( $wpdb->prepare("SELECT progress FROM {$table} WHERE id=%d", $id) );
			if ( $delta === 1 ) {
				$wpdb->update( $table, ['progress'=>$cur+1], ['id'=>$id] );
				$wpdb->insert( $visit_table, ['cardholder_id'=>$id, 'visit_time'=>$now, 'service_note'=>$data['service']] );
			} elseif ( $delta === -1 && $cur > 0 ) {
				$wpdb->update( $table, ['progress'=>$cur-1], ['id'=>$id] );
				$vid = $wpdb->get_var( $wpdb->prepare("SELECT id FROM {$visit_table} WHERE cardholder_id=%d ORDER BY visit_time DESC, id DESC LIMIT 1", $id) );
				if ( $vid ) { $wpdb->delete( $visit_table, ['id'=>intval($vid)] ); }
			}
			$wpdb->update( $table, ['updated_at'=>$now], ['id'=>$id] );
			echo '<div class="notice notice-success"><p>Progress updated.</p></div>';
		}
	}

	// Delete (from Quick Edit)
	if ( isset($_POST['lcm_delete_cardholder']) && isset($_POST['cardholder_id']) ) {
		$id = intval($_POST['cardholder_id']);
		if ( wp_verify_nonce( $_POST['_wpnonce'] ?? '', 'lcm_del_'.$id ) ) {
			// delete visits then cardholder
			$wpdb->delete( $visit_table, ['cardholder_id'=>$id] );
			$wpdb->delete( $table, ['id'=>$id] );
			echo '<div class="notice notice-success"><p>Cardholder deleted.</p></div>';
			// clean URL
			$_GET['edit_id'] = 0;
		}
	}

	$edit_id = isset($_GET['edit_id']) ? intval($_GET['edit_id']) : 0;
	$show_delete = (isset($_GET['delete']) && $_GET['delete'] == '1' && $edit_id && empty($_POST));

	// ------- UI -------
	$table_obj = new LCM_List_Table();
	echo '<div class="wrap">';
	echo '<h1 class="wp-heading-inline">Loyalty Cardholders</h1>';
	echo '<hr class="wp-header-end">';

	// Add form
	echo '<div class="card" style="padding:12px;max-width:1100px;margin:12px 0">';
	echo '<h2 style="margin-top:0">Add Cardholder</h2>';
	echo '<form method="post" style="display:grid;grid-template-columns:repeat(6,1fr);gap:8px">';
	wp_nonce_field('lcm_add');
	echo '<input type="text" name="name" placeholder="Name" required>';
	echo '<input type="email" name="email" placeholder="Email">';
	echo '<input type="text" name="phone" placeholder="Phone">';
	echo '<input type="text" name="service" placeholder="Service">';
	echo '<input type="number" name="progress" min="0" value="0" placeholder="Visits">';
	echo '<input type="text" name="notes" placeholder="Notes" style="grid-column:1 / span 6">';
	echo '<div style="grid-column:1 / span 6"><button class="button button-primary" name="lcm_add_cardholder" value="1">Add Cardholder</button></div>';
	echo '</form>';
	echo '</div>';

	// Quick Edit panel
	if ( $edit_id ) {
		$row = $wpdb->get_row( $wpdb->prepare("SELECT * FROM {$table} WHERE id=%d", $edit_id) );
		if ( $row ) {
			echo '<div class="card" style="padding:12px;max-width:1100px;margin:12px 0 18px 0;border-left:4px solid #2271b1">';
			echo '<h2 style="margin-top:0">Edit Cardholder</h2>';
			if ( $show_delete ) {
				echo '<div class="notice notice-warning"><p><strong>Confirm deletion:</strong> This will remove the cardholder and their visit history.</p></div>';
				echo '<form method="post">';
				wp_nonce_field('lcm_del_'.$row->id);
				echo '<input type="hidden" name="cardholder_id" value="'.intval($row->id).'">';
				echo '<p><button class="button button-secondary" name="lcm_delete_cardholder" value="1">Delete Permanently</button> ';
				echo '<a class="button" href="'.esc_url( remove_query_arg(['delete']) ).'">Cancel</a></p>';
				echo '</form>';
			} else {
				echo '<form method="post">';
				wp_nonce_field('lcm_edit_'.$row->id);
				echo '<input type="hidden" name="cardholder_id" value="'.intval($row->id).'">';
				echo '<table class="form-table"><tbody>';
				echo '<tr><th><label>Name</label></th><td><input class="regular-text" type="text" name="lcm_edit_name" value="'.esc_attr($row->name).'"></td></tr>';
				echo '<tr><th><label>Email</label></th><td><input class="regular-text" type="email" name="lcm_edit_email" value="'.esc_attr($row->email).'"></td></tr>';
				echo '<tr><th><label>Phone</label></th><td><input class="regular-text" type="text" name="lcm_edit_phone" value="'.esc_attr($row->phone).'"></td></tr>';
				echo '<tr><th><label>Service</label></th><td><input class="regular-text" type="text" name="lcm_edit_service" value="'.esc_attr($row->service).'"></td></tr>';
				echo '<tr><th><label>Notes</label></th><td><textarea class="large-text" rows="3" name="lcm_edit_notes">'.esc_textarea($row->notes).'</textarea></td></tr>';
				echo '<tr><th><label>Progress</label></th><td><input type="number" min="0" name="lcm_edit_progress" value="'.intval($row->progress).'"></td></tr>';
				echo '</tbody></table>';
				echo '<p><button class="button button-primary" name="lcm_save_cardholder" value="1">Save</button> ';
				echo '<a class="button" href="'.esc_url( add_query_arg(['delete'=>1]) ).'">Delete…</a> ';
				echo '<a class="button" href="'.esc_url( remove_query_arg('edit_id') ).'">Close</a></p>';
				echo '</form>';
			}
			echo '</div>';
		}
	}

	// Views (Recent/All)
	echo '<ul class="subsubsub">';
	$base = remove_query_arg(['paged','edit_id','delete']);
	$recent = '<a href="'.esc_url( add_query_arg(['view'=>'recent'], $base) ).'" '.( (isset($_GET['view'])?$_GET['view']:'recent')==='recent'?'class="current"':'' ).'>Recent 50</a>';
	$all    = '<a href="'.esc_url( add_query_arg(['view'=>'all'], $base) ).'" '.( (isset($_GET['view'])?$_GET['view']:'recent')==='all'?'class="current"':'' ).'>All</a>';
	echo '<li>'.$recent.' | '.$all.'</li>';
	echo '</ul>';

	echo '<form method="get">';
	echo '<input type="hidden" name="page" value="'.esc_attr( isset($_GET['page'])?$_GET['page']:'lcm-admin' ).'">';
	$table_obj->prepare_items();
	$table_obj->search_box('Search cardholders', 'lcm-search');
	$table_obj->display();
	echo '</form>';
	echo '</div>';
}
