<?php
if ( ! defined( 'ABSPATH' ) ) exit;
if ( ! class_exists( 'WP_List_Table' ) ) {
	require_once ABSPATH . 'wp-admin/includes/class-wp-list-table.php';
}

class LCM_List_Table extends WP_List_Table {
	private $table_name;
	private $per_page;
	private $view;
	private $letter;
	private $when;

	public function __construct() {
		parent::__construct([ 'singular' => 'Cardholder', 'plural' => 'Cardholders', 'ajax' => false ]);
		global $wpdb;
		$this->table_name = $wpdb->prefix . 'loyalty_cards';
		$this->view   = isset($_GET['view']) ? sanitize_key($_GET['view']) : 'recent';
		$this->letter = isset($_GET['letter']) ? strtoupper(substr(sanitize_text_field($_GET['letter']),0,1)) : '';
		$this->when   = isset($_GET['when']) ? sanitize_key($_GET['when']) : '';
		$this->per_page = 100;
	}

	private function sel($val){ return ($val===$this->when) ? ' selected="selected"' : ''; }

	public function get_columns() {
		return [
			'name'      => 'Name',
			'email'     => 'Email',
			'phone'     => 'Phone',
			'notes'     => 'Notes',
			'service'   => 'Service',
			'progress'  => 'Progress',
			'updated_at'=> 'Last Updated',
			'actions'   => 'Actions',
		];
	}

	public function get_sortable_columns() {
		return [ 'name' => ['name',false], 'updated_at' => ['updated_at',true] ];
	}

	public function column_name( $item ) {
		$edit = esc_url( add_query_arg( ['page'=> 'lcm-admin', 'view' => isset($_GET['view'])?sanitize_key($_GET['view']):'recent', 'edit_id' => $item->id ], admin_url('admin.php') ) );
		$actions = [ 'edit' => sprintf('<a href="%s">Edit</a>', $edit) ];
		return sprintf('<strong>%s</strong> %s', esc_html($item->name), $this->row_actions($actions));
	}

	public function column_default( $item, $col ) {
		switch ($col) {
			case 'email': return esc_html($item->email);
			case 'phone': return esc_html($item->phone);
			case 'notes': return esc_html(isset($item->notes)?$item->notes:'');
			case 'service': return esc_html(isset($item->service)?$item->service:'');
			case 'progress':
			$dec = '<form method="post" style="display:inline;margin:0">'
				.wp_nonce_field('lcm_prog_'.$item->id, '_wpnonce', true, false)
				.'<input type="hidden" name="lcm_progress_delta" value="-1">'
				.'<input type="hidden" name="cardholder_id" value="'.intval($item->id).'">'
				.'<button class="button button-small" style="width:26px">-</button></form>';
			$inc = '<form method="post" style="display:inline;margin:0">'
				.wp_nonce_field('lcm_prog_'.$item->id, '_wpnonce', true, false)
				.'<input type="hidden" name="lcm_progress_delta" value="1">'
				.'<input type="hidden" name="cardholder_id" value="'.intval($item->id).'">'
				.'<button class="button button-small" style="width:26px">+</button></form>';
			return $dec.' <strong>'.intval($item->progress).'</strong> '.$inc;
			case 'updated_at': return esc_html( mysql2date( get_option('date_format').' '.get_option('time_format'), $item->updated_at ) );
			case 'actions':
				$edit = esc_url( add_query_arg( ['page'=> 'lcm-admin', 'view' => isset($_GET['view'])?sanitize_key($_GET['view']):'recent', 'edit_id' => $item->id ], admin_url('admin.php') ) );
				$view = esc_url( add_query_arg( ['page'=>'lcm-cardholder-details','id'=>$item->id], admin_url('admin.php') ) );
				$del  = esc_url( add_query_arg( ['page'=>'lcm-admin', 'view' => isset($_GET['view'])?sanitize_key($_GET['view']):'recent', 'edit_id'=>$item->id], admin_url('admin.php') ) );
				return sprintf('<a class="button button-small" href="%s">Edit</a> <a class="button button-small" href="%s">View Visits</a> <a class="button button-small delete" href="%s">Delete…</a>', $edit, $view, $del);
		}
		return '';
	}

	public function extra_tablenav( $which ) {
		$base = remove_query_arg(['paged']);
		$letters = range('A','Z');
		echo '<div class="alignleft actions">';
		echo '<div style="display:flex;gap:6px;flex-wrap:wrap;max-width:760px">';
		$link_all = esc_url( add_query_arg( array_filter([ 'view'=>$this->view, 'letter'=>false, 'when'=>$this->when?:false ]), $base ) );
		echo '<a class="button '.( $this->letter==='' ? 'button-primary' : '' ).'" href="'.$link_all.'">All</a>';
		foreach ( $letters as $L ) {
			$link = esc_url( add_query_arg( array_filter([ 'view'=>$this->view, 'letter'=>$L, 'when'=>$this->when?:false ]), $base ) );
			$cur = $this->letter === $L ? 'button-primary' : '';
			echo '<a class="button '.$cur.'" href="'.$link.'">'.$L.'</a>';
		}
		echo '</div>';
		$when_options = ['' => 'Any time', 'today' => 'Edited Today', 'week' => 'Edited This Week'];
		echo '<select name="when" id="when" style="margin-left:8px">';
		foreach ( $when_options as $val => $label ) {
			echo '<option value="'.esc_attr($val).'"'.$this->sel($val).'>'.esc_html($label).'</option>';
		}
		echo '</select>';
		submit_button('Apply', 'secondary', '', false, ['style'=>'margin-left:4px']);
		echo '</div>';
	}

	public function prepare_items() {
		global $wpdb;
		$columns  = $this->get_columns();
		$hidden   = [];
		$sortable = $this->get_sortable_columns();
		$this->_column_headers = [$columns, $hidden, $sortable];

		$search  = isset($_REQUEST['s']) ? trim(wp_unslash($_REQUEST['s'])) : '';
		$orderby = isset($_REQUEST['orderby']) ? sanitize_key($_REQUEST['orderby']) : 'updated_at';
		$order   = ( isset($_REQUEST['order']) && in_array(strtoupper($_REQUEST['order']), ['ASC','DESC'], true) ) ? strtoupper($_REQUEST['order']) : 'DESC';

		$where   = 'WHERE 1=1';
		$params  = [];

		if ( $search !== '' ) {
			$where .= ' AND (name LIKE %s OR email LIKE %s)';
			$like = '%' . $wpdb->esc_like( $search ) . '%';
			$params[] = $like; $params[] = $like;
		}
		if ( !empty($this->letter) ) {
			$where .= ' AND name LIKE %s';
			$params[] = $this->letter . '%';
		}
		if ( $this->when === 'today' ) {
			$where .= ' AND DATE(updated_at) = CURDATE()';
		} elseif ( $this->when === 'week' ) {
			$where .= ' AND updated_at >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)';
		}

		$orderby_sql = in_array($orderby, ['name','updated_at'], true) ? $orderby : 'updated_at';
		$order_sql   = $order;

		if ( $this->view === 'recent' && $search === '' && empty($this->letter) && empty($this->when) ) {
			$sql = "SELECT id, name, email, phone, notes, service, progress, updated_at
					FROM {$this->table_name}
					{$where}
					ORDER BY updated_at DESC
					LIMIT 50";
			$this->items = $wpdb->get_results( $wpdb->prepare( $sql, $params ) );
			$this->set_pagination_args([ 'total_items'=>50, 'per_page'=>50, 'total_pages'=>1 ]);
			return;
		}

		$paged    = max( 1, isset($_GET['paged']) ? intval($_GET['paged']) : 1 );
		$offset   = ( $paged - 1 ) * $this->per_page;

		$count_sql = "SELECT COUNT(*) FROM {$this->table_name} {$where}";
		$total_items = (int) $wpdb->get_var( $wpdb->prepare( $count_sql, $params ) );

		$data_sql = "SELECT id, name, email, phone, notes, service, progress, updated_at
					 FROM {$this->table_name}
					 {$where}
					 ORDER BY {$orderby_sql} {$order_sql}
					 LIMIT %d OFFSET %d";
		$this->items = $wpdb->get_results( $wpdb->prepare( $data_sql, array_merge($params,[ $this->per_page, $offset ]) ) );

		$this->set_pagination_args([ 'total_items'=>$total_items, 'per_page'=>$this->per_page, 'total_pages'=> max(1, ceil($total_items/$this->per_page)) ]);
	}
}
