<?php
function lcm_render_admin_page() {
    // v3.04: Show paginated admin by default and bypass legacy handlers
    if ( ! isset($_GET['legacy']) ) {
        if ( ! function_exists('lcm_render_paginated_page') ) {
            require_once plugin_dir_path(__FILE__) . 'admin/partials/lcm-paginated-page.php';
        }
        lcm_render_paginated_page();
        return;
    }

    global $wpdb;
    $table_name = $wpdb->prefix . 'loyalty_cards';
    $visit_table = $wpdb->prefix . 'loyalty_visits';

    // Add new cardholder
    if (isset($_POST['lcm_add_cardholder'])) {
        $name = sanitize_text_field($_POST['lcm_name']);
        $email = sanitize_email($_POST['lcm_email']);
        $phone = sanitize_text_field($_POST['lcm_phone']);
        $notes = sanitize_textarea_field($_POST['lcm_notes']);
        $service = sanitize_text_field($_POST['lcm_service']);
        $wpdb->insert($table_name, array(
            'name' => $name,
            'email' => $email,
            'phone' => $phone,
            'service' => $service,
            'notes' => $notes,
            'progress' => 0,
            'reward_sent' => 0
        ));
        // v3.01: set updated_at on insert
        $wpdb->update($table_name, array('updated_at' => current_time('mysql')), array('id' => $wpdb->insert_id));
    
        echo '<div class="notice notice-success is-dismissible"><p>Cardholder added successfully.</p></div>';
    }

    // Delete cardholder
    if (isset($_GET['lcm_delete']) && is_numeric($_GET['lcm_delete'])) {
        $wpdb->delete($table_name, array('id' => intval($_GET['lcm_delete'])));
    }

    // Save updates
    if (isset($_POST['lcm_save_cardholder']) && isset($_POST['cardholder_id'])) {
        $id = intval($_POST['cardholder_id']);
        $name = sanitize_text_field($_POST['lcm_edit_name']);
        $email = sanitize_email($_POST['lcm_edit_email']);
        $phone = sanitize_text_field($_POST['lcm_edit_phone']);
        $notes = sanitize_textarea_field($_POST['lcm_edit_notes']);
        $service = sanitize_text_field($_POST['lcm_edit_service']);
        $progress = isset($_POST['lcm_edit_progress']) ? intval($_POST['lcm_edit_progress']) : 0;

        $prev = $wpdb->get_row($wpdb->prepare("SELECT progress, redemptions FROM $table_name WHERE id = %d", $id));
        $prev_progress = intval($prev->progress);

        
        $goal = intval(get_option('lcm_total_checkmarks', 10));
        if ($progress >= $goal) {
            $wpdb->insert($table_name, array(
            'name' => $name,
            'email' => $email,
            'phone' => $phone,
            'service' => $service,
            'notes' => $notes,
            'progress' => 0,
            'reward_sent' => 0
        ));
        // v3.01: set updated_at on update
        $wpdb->update($table_name, array('updated_at' => current_time('mysql')), array('id' => $id));
    
        } else {
            $wpdb->update($table_name, array(
                'name' => $name,
                'email' => $email,
                'phone' => $phone,
            'service' => $service,
                'notes' => $notes,
                'progress' => $progress
            ), array('id' => $id));
        }

        if ($progress > $prev_progress) {
    // Ensure loyalty_visits table exists
    if ($wpdb->get_var("SHOW TABLES LIKE '$visit_table'") != $visit_table) {
        $charset_collate = $wpdb->get_charset_collate();
        $sql = "CREATE TABLE $visit_table (
            id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
            cardholder_id BIGINT(20) UNSIGNED NOT NULL,
            visit_time DATETIME NOT NULL,
            service_note TEXT,
            PRIMARY KEY  (id),
            KEY cardholder_id (cardholder_id)
        ) $charset_collate;";
        require_once ABSPATH . 'wp-admin/includes/upgrade.php';
        dbDelta($sql);
    } else {
        // Ensure service_note column exists
        $col = $wpdb->get_results("SHOW COLUMNS FROM `$visit_table` LIKE 'service_note'");
        if (empty($col)) {
            $wpdb->query("ALTER TABLE `$visit_table` ADD `service_note` TEXT DEFAULT NULL");
        }
    }

    // Insert visit with note
    $wpdb->insert(
        $visit_table,
        array(
            'cardholder_id' => $id,
            'visit_time'    => current_time('mysql'),
            'service_note'  => $service
        ),
        array('%d','%s','%s')
    );

    // Clear the service cell so it's ready next time
    $wpdb->update($table_name, array('service' => ''), array('id' => $id));
}
    }

    $rows = $wpdb->get_results("SELECT * FROM $table_name ORDER BY name ASC");
    $max = intval(get_option('lcm_total_checkmarks', 10));

    
    // v3.01: show paginated list by default; use &legacy=1 for original editor
    if ( ! isset($_GET['legacy']) ) {
        if ( ! function_exists('lcm_render_paginated_page') ) {
            require_once plugin_dir_path(__FILE__) . 'admin/partials/lcm-paginated-page.php';
        }
        lcm_render_paginated_page();
        return;
    }

    echo '<div class="wrap"><h1>Loyalty Card Manager</h1>';
    echo '<form method="post">';
    echo '<h2>Add New Cardholder</h2>';
    echo '<p><input type="text" name="lcm_name" placeholder="Name" required>';
    echo '<input type="email" name="lcm_email" placeholder="Email">';
    echo '<input type="text" name="lcm_phone" placeholder="Phone">';
    echo '<input type="text" name="lcm_notes" placeholder="Notes">';
    echo '<input type="submit" name="lcm_add_cardholder" class="button button-primary" value="Add Cardholder"></p>';
    echo '</form>';

    echo '<h2>All Cardholders</h2>';
    echo '<table class="widefat fixed striped"><thead><tr><th>Name</th><th>Email</th><th>Phone</th><th>Notes</th><th>Service</th><th>Progress</th><th>Actions</th></tr></thead><tbody>';
    foreach ($rows as $row) {
        echo '<tr>';
        echo '<form method="post">';
        echo '<input type="hidden" name="cardholder_id" value="' . intval($row->id) . '">';
        echo '<td><input type="text" name="lcm_edit_name" value="' . esc_attr($row->name) . '"></td>';
        echo '<td><input type="email" name="lcm_edit_email" value="' . esc_attr($row->email) . '"></td>';
        echo '<td><input type="text" name="lcm_edit_phone" value="' . esc_attr($row->phone) . '"></td>';
        echo '<td><input type="text" name="lcm_edit_notes" value="' . esc_attr($row->notes) . '"></td>';
        echo '<td><input type="text" name="lcm_edit_service" value="' . esc_attr($row->service) . '"></td>';
        echo '<td><input type="number" name="lcm_edit_progress" value="' . intval($row->progress) . '" min="0" max="' . $max . '"></td>';
        echo '<td>';
        echo '<input type="submit" name="lcm_save_cardholder" value="Save" class="button"> ';
        echo '<a href="?page=lcm-admin&lcm_delete=' . intval($row->id) . '" class="button delete">Delete</a> ';
        echo '<a href="?page=lcm-cardholder-details&id=' . intval($row->id) . '" class="button">View Visits</a>';
        echo '</td>';
        echo '</form>';
        echo '</tr>';
    }
    echo '</tbody></table>';
    echo '</div>';
}